//
//  MCQualifierView.h
//  MCApplication
//
//  Created by Alykhan Jetha on Mon Jul 07 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>
#import "MCModelEditor.h"

@class BDQualifier;

@interface MCQualifierView : MCModelEditor {
	IBOutlet		NSTextField			*labelField;
	IBOutlet		NSButton			*removeButton;
	
	
	
	
	BOOL								forcedMandatory;							
	
	NSDictionary						*configurationDictionary;	
}

- (void)setConfigurationDictionary:(NSDictionary *)config;
- (NSDictionary *)configurationDictionary;

// adds mandatory message to the array is the qualifier is mandatory and if the user has not entered a value
- (void)addMandatoryMessageIfApplicable:(NSMutableArray *)array;
// subclasses return YES or NO
- (BOOL)hasMandatoryValues;

- (IBAction)removeQualifier:(id)sender;

// hides the remove button
- (void)makeForcedDisplay;
- (void)makeOptional;

- (NSString *)qualifierKeyPath;

- (BDQualifier *)buildQualifierAndAddIntoArray:(NSMutableArray *)array;

// Looks in configuration dictionary and sets the state(i.e. values for textfields, selected items in popups) from the keys if they exist
- (void)setStateFromConfigurationDictionary;

// Adds keys to the configuration dictionary that represent the state
- (void)setConfigurationDictionaryFromState;

- (void)removeFromSuperview;
@end
